package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CrossVersionObjectReference contains enough information to let you identify the referred resource.
 *
 *  @param       kind  kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param       name  name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
 *  @param apiVersion  apiVersion is the API version of the referent
*/
case class CrossVersionObjectReference(
  kind: String,
  name: String,
  apiVersion: Option[String] = None
)

object CrossVersionObjectReference {
  implicit lazy val encoder: Encoder.AsObject[CrossVersionObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[CrossVersionObjectReference] = deriveDecoder
}
