package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceConversion describes how to convert different versions of a CR.
 *
 *  @param strategy  strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`:
 *                   The converter only change the apiVersion and would not touch any other field in the custom resource. -
 *                   `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
 *                   is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook
 *                   to be set.
 *  @param  webhook  webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
*/
case class CustomResourceConversion(
  strategy: String,
  webhook: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.WebhookConversion] = None
)

object CustomResourceConversion {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceConversion] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceConversion] = deriveDecoder
}
