package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionCondition contains details for the current condition of this pod.
 *
 *  @param             `type`  type is the type of the condition. Types include Established, NamesAccepted and Terminating.
 *  @param             status  status is the status of the condition. Can be True, False, Unknown.
 *  @param lastTransitionTime  lastTransitionTime last time the condition transitioned from one status to another.
 *  @param            message  message is a human-readable message indicating details about last transition.
 *  @param             reason  reason is a unique, one-word, CamelCase reason for the condition's last transition.
*/
case class CustomResourceDefinitionCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object CustomResourceDefinitionCondition {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionCondition] = deriveDecoder
}
