package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 *  @param      items  items list individual CustomResourceDefinition objects
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
*/
case class CustomResourceDefinitionList(
  items: Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object CustomResourceDefinitionList {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionList] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionList] = deriveDecoder
}
