package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionSpec describes how a user wants their resource to appear
 *
 *  @param                 group  group is the API group of the defined custom resource. The custom resources are served under
 *                                `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form
 *                                `<names.plural>.<group>`).
 *  @param                 names  names specify the resource and kind names for the custom resource.
 *  @param                 scope  scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed
 *                                values are `Cluster` and `Namespaced`.
 *  @param              versions  versions is the list of all API versions of the defined custom resource. Version names are
 *                                used to compute the order in which served versions are listed in API discovery. If the version
 *                                string is "kube-like", it will sort above non "kube-like" version strings, which are ordered
 *                                lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the
 *                                major version), then optionally the string "alpha" or "beta" and another number (the minor
 *                                version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix
 *                                such as beta or alpha), and then by comparing major version, then minor version. An example
 *                                sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1,
 *                                foo10.
 *  @param            conversion  conversion defines conversion settings for the CRD.
 *  @param preserveUnknownFields  preserveUnknownFields indicates that object fields which are not specified in the OpenAPI
 *                                schema should be preserved when persisting to storage. apiVersion, kind, metadata and known
 *                                fields inside metadata are always preserved. This field is deprecated in favor of setting
 *                                `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning
 *                                for details.
*/
case class CustomResourceDefinitionSpec(
  group: String,
  names: io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames,
  scope: String,
  versions: Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion],
  conversion: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] = None,
  preserveUnknownFields: Option[Boolean] = None
)

object CustomResourceDefinitionSpec {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionSpec] = deriveDecoder
}
