package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
 *
 *  @param  acceptedNames  acceptedNames are the names that are actually being used to serve discovery. They may be different
 *                         than the names in spec.
 *  @param     conditions  conditions indicate state for particular aspects of a CustomResourceDefinition
 *  @param storedVersions  storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions
 *                         allows a migration path for stored versions in etcd. The field is mutable so a migration controller
 *                         can finish a migration to another version (ensuring no old objects are left in storage), and then
 *                         remove the rest of the versions from this list. Versions may not be removed from `spec.versions`
 *                         while they exist in this list.
*/
case class CustomResourceDefinitionStatus(
  acceptedNames: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] = None,
  conditions: Option[Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]] = None,
  storedVersions: Option[Seq[String]] = None
)

object CustomResourceDefinitionStatus {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionStatus] = deriveDecoder
}
