package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceDefinitionVersion describes a version for CRD.
 *
 *  @param                     name  name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under
 *                                   this version at `/apis/<group>/<version>/...` if `served` is true.
 *  @param                   served  served is a flag enabling/disabling this version from being served via REST APIs
 *  @param                  storage  storage indicates this version should be used when persisting custom resources to storage.
 *                                   There must be exactly one version with storage=true.
 *  @param additionalPrinterColumns  additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables
 *                                   for details. If no columns are specified, a single column displaying the age of the custom
 *                                   resource is used.
 *  @param               deprecated  deprecated indicates this version of the custom resource API is deprecated. When set to
 *                                   true, API requests to this version receive a warning header in the server response. Defaults
 *                                   to false.
 *  @param       deprecationWarning  deprecationWarning overrides the default warning returned to API clients. May only be
 *                                   set when `deprecated` is true. The default warning indicates this version is deprecated
 *                                   and recommends use of the newest served version of equal or greater stability, if one exists
 *  @param                   schema  schema describes the schema used for validation, pruning, and defaulting of this version
 *                                   of the custom resource.
 *  @param         selectableFields  selectableFields specifies paths to fields that may be used as field selectors. A maximum
 *                                   of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
 *  @param             subresources  subresources specify what subresources this version of the defined custom resource have
*/
case class CustomResourceDefinitionVersion(
  name: String,
  served: Boolean,
  storage: Boolean,
  additionalPrinterColumns: Option[Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]] = None,
  deprecated: Option[Boolean] = None,
  deprecationWarning: Option[String] = None,
  schema: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = None,
  selectableFields: Option[Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.SelectableField]] = None,
  subresources: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = None
)

object CustomResourceDefinitionVersion {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionVersion] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionVersion] = deriveDecoder
}
