package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DownwardAPIVolumeFile represents information to create the file containing the pod field
 *
 *  @param             path  Required: Path is  the relative path name of the file to be created. Must not be absolute or contain
 *                           the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with
 *                           '..'
 *  @param         fieldRef  Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported
 *  @param             mode  Optional: mode bits used to set permissions on this file, must be an octal value between 0000
 *                           and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON
 *                           requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This
 *                           might be in conflict with other options that affect the file mode, like fsGroup, and the result
 *                           can be other mode bits set.
 *  @param resourceFieldRef  Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory,
 *                           requests.cpu and requests.memory) are currently supported.
*/
case class DownwardAPIVolumeFile(
  path: String,
  fieldRef: Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  mode: Option[Int] = None,
  resourceFieldRef: Option[io.k8s.api.core.v1.ResourceFieldSelector] = None
)

object DownwardAPIVolumeFile {
  implicit lazy val encoder: Encoder.AsObject[DownwardAPIVolumeFile] = deriveEncoder
  implicit lazy val decoder: Decoder[DownwardAPIVolumeFile] = deriveDecoder
}
