package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EndpointAddress is a tuple that describes single IP address.
 *
 *  @param        ip  The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10),
 *                    or link-local multicast (224.0.0.0/24 or ff02::/16).
 *  @param  hostname  The Hostname of this endpoint
 *  @param  nodeName  Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
 *  @param targetRef  Reference to object providing the endpoint.
*/
case class EndpointAddress(
  ip: String,
  hostname: Option[String] = None,
  nodeName: Option[String] = None,
  targetRef: Option[io.k8s.api.core.v1.ObjectReference] = None
)

object EndpointAddress {
  implicit lazy val encoder: Encoder.AsObject[EndpointAddress] = deriveEncoder
  implicit lazy val decoder: Decoder[EndpointAddress] = deriveDecoder
}
