package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EventSource contains information for an event.
 *
 *  @param component  Component from which the event is generated.
 *  @param      host  Node name on which the event is generated.
*/
case class EventSource(
  component: Option[String] = None,
  host: Option[String] = None
)

object EventSource {
  implicit lazy val encoder: Encoder.AsObject[EventSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EventSource] = deriveDecoder
}
