package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** FieldSelectorRequirement is a selector that contains values, a key, and an operator that relates the key and values.
 *
 *  @param      key  key is the field selector key that the requirement applies to.
 *  @param operator  operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
 *                   The list of operators may grow in the future.
 *  @param   values  values is an array of string values. If the operator is In or NotIn, the values array must be non-empty.
 *                   If the operator is Exists or DoesNotExist, the values array must be empty.
*/
case class FieldSelectorRequirement(
  key: String,
  operator: String,
  values: Option[Seq[String]] = None
)

object FieldSelectorRequirement {
  implicit lazy val encoder: Encoder.AsObject[FieldSelectorRequirement] = deriveEncoder
  implicit lazy val decoder: Decoder[FieldSelectorRequirement] = deriveDecoder
}
