package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
 *
 *  @param paths  paths is a collection of paths that map requests to backends.
*/
case class HTTPIngressRuleValue(
  paths: Seq[io.k8s.api.networking.v1.HTTPIngressPath]
)

object HTTPIngressRuleValue {
  implicit lazy val encoder: Encoder.AsObject[HTTPIngressRuleValue] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPIngressRuleValue] = deriveDecoder
}
