package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** configuration of a horizontal pod autoscaler.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
 *  @param     status  status is the current information about the autoscaler.
*/
case class HorizontalPodAutoscaler(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = None,
  status: Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = None
)

object HorizontalPodAutoscaler {
  implicit lazy val encoder: Encoder.AsObject[HorizontalPodAutoscaler] = deriveEncoder
  implicit lazy val decoder: Decoder[HorizontalPodAutoscaler] = deriveDecoder
}
