package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** specification of a horizontal pod autoscaler.
 *
 *  @param                 scaleTargetRef  reference to scaled resource; horizontal pod autoscaler will learn the current resource
 *                                         consumption and will set the desired number of pods by using its Scale subresource
 *  @param                    maxReplicas  maxReplicas is the upper limit for the number of pods that can be set by the autoscaler;
 *                                         cannot be smaller than MinReplicas.
 *  @param                    minReplicas  minReplicas is the lower limit for the number of replicas to which the autoscaler
 *                                         can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha
 *                                         feature gate HPAScaleToZero is enabled and at least one Object or External metric
 *                                         is configured.  Scaling is active as long as at least one metric value is available
 *  @param targetCPUUtilizationPercentage  targetCPUUtilizationPercentage is the target average CPU utilization (represented
 *                                         as a percentage of requested CPU) over all the pods; if not specified the default
 *                                         autoscaling policy will be used.
*/
case class HorizontalPodAutoscalerSpec(
  scaleTargetRef: io.k8s.api.autoscaling.v1.CrossVersionObjectReference,
  maxReplicas: Int,
  minReplicas: Option[Int] = None,
  targetCPUUtilizationPercentage: Option[Int] = None
)

object HorizontalPodAutoscalerSpec {
  implicit lazy val encoder: Encoder.AsObject[HorizontalPodAutoscalerSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[HorizontalPodAutoscalerSpec] = deriveDecoder
}
