package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** HostIP represents a single IP address allocated to the host.
 *
 *  @param ip  IP is the IP address assigned to the host
*/
case class HostIP(
  ip: String
)

object HostIP {
  implicit lazy val encoder: Encoder.AsObject[HostIP] = deriveEncoder
  implicit lazy val decoder: Decoder[HostIP] = deriveDecoder
}
