package io.k8s.api.networking.v1beta1

import io.circe.*
import io.circe.generic.semiauto.*

/** IPAddressList contains a list of IPAddress.
 *
 *  @param      items  items is the list of IPAddresses.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
*/
case class IPAddressList(
  items: Seq[io.k8s.api.networking.v1beta1.IPAddress],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object IPAddressList {
  implicit lazy val encoder: Encoder.AsObject[IPAddressList] = deriveEncoder
  implicit lazy val decoder: Decoder[IPAddressList] = deriveDecoder
}
