package io.k8s.api.networking.v1beta1

import io.circe.*
import io.circe.generic.semiauto.*

/** IPAddressSpec describe the attributes in an IP Address.
 *
 *  @param parentRef  ParentRef references the resource that an IPAddress is attached to. An IPAddress must reference a parent
 *                    object.
*/
case class IPAddressSpec(
  parentRef: io.k8s.api.networking.v1beta1.ParentReference
)

object IPAddressSpec {
  implicit lazy val encoder: Encoder.AsObject[IPAddressSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[IPAddressSpec] = deriveDecoder
}
