package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
 *
 *  @param   cidr  cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
 *  @param except  except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24"
 *                 or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
*/
case class IPBlock(
  cidr: String,
  except: Option[Seq[String]] = None
)

object IPBlock {
  implicit lazy val encoder: Encoder.AsObject[IPBlock] = deriveEncoder
  implicit lazy val decoder: Decoder[IPBlock] = deriveDecoder
}
