package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
 *
 *  @param      kind  kind is the type of resource being referenced.
 *  @param      name  name is the name of resource being referenced.
 *  @param  apiGroup  apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified
 *                    Kind must be in the core API group. For any other third-party types, APIGroup is required.
 *  @param namespace  namespace is the namespace of the resource being referenced. This field is required when scope is set
 *                    to "Namespace" and must be unset when scope is set to "Cluster".
 *  @param     scope  scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster"
 *                    (default) or "Namespace".
*/
case class IngressClassParametersReference(
  kind: String,
  name: String,
  apiGroup: Option[String] = None,
  namespace: Option[String] = None,
  scope: Option[String] = None
)

object IngressClassParametersReference {
  implicit lazy val encoder: Encoder.AsObject[IngressClassParametersReference] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressClassParametersReference] = deriveDecoder
}
