package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressClassSpec provides information about the class of an Ingress.
 *
 *  @param controller  controller refers to the name of the controller that should handle this class. This allows for different
 *                     "flavors" that are controlled by the same controller. For example, you may have different parameters
 *                     for the same implementing controller. This should be specified as a domain-prefixed path no more than
 *                     250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
 *  @param parameters  parameters is a link to a custom resource containing additional configuration for the controller. This
 *                     is optional if the controller does not require extra parameters.
*/
case class IngressClassSpec(
  controller: Option[String] = None,
  parameters: Option[io.k8s.api.networking.v1.IngressClassParametersReference] = None
)

object IngressClassSpec {
  implicit lazy val encoder: Encoder.AsObject[IngressClassSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressClassSpec] = deriveDecoder
}
