package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
 *
 *  @param hostname  hostname is set for load-balancer ingress points that are DNS based.
 *  @param       ip  ip is set for load-balancer ingress points that are IP based.
 *  @param    ports  ports provides information about the ports exposed by this LoadBalancer.
*/
case class IngressLoadBalancerIngress(
  hostname: Option[String] = None,
  ip: Option[String] = None,
  ports: Option[Seq[io.k8s.api.networking.v1.IngressPortStatus]] = None
)

object IngressLoadBalancerIngress {
  implicit lazy val encoder: Encoder.AsObject[IngressLoadBalancerIngress] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressLoadBalancerIngress] = deriveDecoder
}
