package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressLoadBalancerStatus represents the status of a load-balancer.
 *
 *  @param ingress  ingress is a list containing ingress points for the load-balancer.
*/
case class IngressLoadBalancerStatus(
  ingress: Option[Seq[io.k8s.api.networking.v1.IngressLoadBalancerIngress]] = None
)

object IngressLoadBalancerStatus {
  implicit lazy val encoder: Encoder.AsObject[IngressLoadBalancerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressLoadBalancerStatus] = deriveDecoder
}
