package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressPortStatus represents the error condition of a service port
 *
 *  @param     port  port is the port number of the ingress port.
 *  @param protocol  protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
 *  @param    error  error is to record the problem with the service port The format of the error shall comply with the following
 *                   rules: - built-in error values shall be specified in this file and those shall use
 *                   CamelCase names
 *                   - cloud provider specific error values must have names that comply with the
 *                   format foo.example.com/CamelCase.
*/
case class IngressPortStatus(
  port: Int,
  protocol: String,
  error: Option[String] = None
)

object IngressPortStatus {
  implicit lazy val encoder: Encoder.AsObject[IngressPortStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressPortStatus] = deriveDecoder
}
