package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressServiceBackend references a Kubernetes Service as a Backend.
 *
 *  @param name  name is the referenced service. The service must exist in the same namespace as the Ingress object.
 *  @param port  port of the referenced service. A port name or port number is required for a IngressServiceBackend.
*/
case class IngressServiceBackend(
  name: String,
  port: Option[io.k8s.api.networking.v1.ServiceBackendPort] = None
)

object IngressServiceBackend {
  implicit lazy val encoder: Encoder.AsObject[IngressServiceBackend] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressServiceBackend] = deriveDecoder
}
