package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** IngressStatus describe the current state of the Ingress.
 *
 *  @param loadBalancer  loadBalancer contains the current status of the load-balancer.
*/
case class IngressStatus(
  loadBalancer: Option[io.k8s.api.networking.v1.IngressLoadBalancerStatus] = None
)

object IngressStatus {
  implicit lazy val encoder: Encoder.AsObject[IngressStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressStatus] = deriveDecoder
}
