package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** JobTemplateSpec describes the data a Job should have when created from a template
 *
 *  @param metadata  Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param     spec  Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class JobTemplateSpec(
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.batch.v1.JobSpec] = None
)

object JobTemplateSpec {
  implicit lazy val encoder: Encoder.AsObject[JobTemplateSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[JobTemplateSpec] = deriveDecoder
}
