package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
 *
 *  @param matchExpressions  matchExpressions is a list of label selector requirements. The requirements are ANDed.
 *  @param      matchLabels  matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent
 *                           to an element of matchExpressions, whose key field is "key", the operator is "In", and the values
 *                           array contains only "value". The requirements are ANDed.
*/
case class LabelSelector(
  matchExpressions: Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]] = None,
  matchLabels: Option[Map[String, String]] = None
)

object LabelSelector {
  implicit lazy val encoder: Encoder.AsObject[LabelSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[LabelSelector] = deriveDecoder
}
