package io.k8s.api.coordination.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LeaseSpec is a specification of a Lease.
 *
 *  @param          acquireTime  acquireTime is a time when the current lease was acquired.
 *  @param       holderIdentity  holderIdentity contains the identity of the holder of a current lease. If Coordinated Leader
 *                               Election is used, the holder identity must be equal to the elected LeaseCandidate.metadata.name
 *                               field.
 *  @param leaseDurationSeconds  leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire
 *                               it. This is measured against the time of last observed renewTime.
 *  @param     leaseTransitions  leaseTransitions is the number of transitions of a lease between holders.
 *  @param      preferredHolder  PreferredHolder signals to a lease holder that the lease has a more optimal holder and should
 *                               be given up. This field can only be set if Strategy is also set.
 *  @param            renewTime  renewTime is a time when the current holder of a lease has last updated the lease.
 *  @param             strategy  Strategy indicates the strategy for picking the leader for coordinated leader election. If
 *                               the field is not specified, there is no active coordination for this lease. (Alpha) Using this
 *                               field requires the CoordinatedLeaderElection feature gate to be enabled.
*/
case class LeaseSpec(
  acquireTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  holderIdentity: Option[String] = None,
  leaseDurationSeconds: Option[Int] = None,
  leaseTransitions: Option[Int] = None,
  preferredHolder: Option[String] = None,
  renewTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  strategy: Option[String] = None
)

object LeaseSpec {
  implicit lazy val encoder: Encoder.AsObject[LeaseSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[LeaseSpec] = deriveDecoder
}
