package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified.
 *
 *  @param      exec  Exec specifies the action to take.
 *  @param   httpGet  HTTPGet specifies the http request to perform.
 *  @param     sleep  Sleep represents the duration that the container should sleep before being terminated.
 *  @param tcpSocket  Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for the backward compatibility.
 *                    There are no validation of this field and lifecycle hooks will fail in runtime when tcp handler is specified
*/
case class LifecycleHandler(
  exec: Option[io.k8s.api.core.v1.ExecAction] = None,
  httpGet: Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  sleep: Option[io.k8s.api.core.v1.SleepAction] = None,
  tcpSocket: Option[io.k8s.api.core.v1.TCPSocketAction] = None
)

object LifecycleHandler {
  implicit lazy val encoder: Encoder.AsObject[LifecycleHandler] = deriveEncoder
  implicit lazy val decoder: Decoder[LifecycleHandler] = deriveDecoder
}
