package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LimitRange sets resource usage limits for each kind of resource in a Namespace.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class LimitRange(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.core.v1.LimitRangeSpec] = None
)

object LimitRange {
  implicit lazy val encoder: Encoder.AsObject[LimitRange] = deriveEncoder
  implicit lazy val decoder: Decoder[LimitRange] = deriveDecoder
}
