package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LinuxContainerUser represents user identity information in Linux containers
 *
 *  @param                uid  UID is the primary uid initially attached to the first process in the container
 *  @param                gid  GID is the primary gid initially attached to the first process in the container
 *  @param supplementalGroups  SupplementalGroups are the supplemental groups initially attached to the first process in the
 *                             container
*/
case class LinuxContainerUser(
  uid: Long,
  gid: Long,
  supplementalGroups: Option[Seq[Long]] = None
)

object LinuxContainerUser {
  implicit lazy val encoder: Encoder.AsObject[LinuxContainerUser] = deriveEncoder
  implicit lazy val decoder: Decoder[LinuxContainerUser] = deriveDecoder
}
