package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
 *
 *  @param hostname  Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
 *  @param       ip  IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack
 *                   load-balancers)
 *  @param   ipMode  IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified.
 *                   Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's
 *                   IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination
 *                   set to the node's IP and node port or the pod's IP and port. Service implementations may use this information
 *                   to adjust traffic routing.
 *  @param    ports  Ports is a list of records of service ports If used, every port defined in the service should have an
 *                   entry in it
*/
case class LoadBalancerIngress(
  hostname: Option[String] = None,
  ip: Option[String] = None,
  ipMode: Option[String] = None,
  ports: Option[Seq[io.k8s.api.core.v1.PortStatus]] = None
)

object LoadBalancerIngress {
  implicit lazy val encoder: Encoder.AsObject[LoadBalancerIngress] = deriveEncoder
  implicit lazy val decoder: Decoder[LoadBalancerIngress] = deriveDecoder
}
