package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
 *
 *  @param name  Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to
 *               be empty. Instances of this type with an empty value here are almost certainly wrong. More info:
 *               https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
*/
case class LocalObjectReference(
  name: Option[String] = None
)

object LocalObjectReference {
  implicit lazy val encoder: Encoder.AsObject[LocalObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[LocalObjectReference] = deriveDecoder
}
