package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Local represents directly-attached storage with node affinity (Beta feature)
 *
 *  @param   path  path of the full path to the volume on the node. It can be either a directory or block device (disk, partition,
 *                 ...).
 *  @param fsType  fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem
 *                 type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select
 *                 a filesystem if unspecified.
*/
case class LocalVolumeSource(
  path: String,
  fsType: Option[String] = None
)

object LocalVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[LocalVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[LocalVolumeSource] = deriveDecoder
}
