package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
 *
 *  @param   server  server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
 *  @param     path  path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
 *  @param readOnly  readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More
 *                   info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
*/
case class NFSVolumeSource(
  server: String,
  path: String,
  readOnly: Option[Boolean] = None
)

object NFSVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[NFSVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[NFSVolumeSource] = deriveDecoder
}
