package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NamespaceSpec describes the attributes on a Namespace.
 *
 *  @param finalizers  Finalizers is an opaque list of values that must be empty to permanently remove object from storage.
 *                     More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
*/
case class NamespaceSpec(
  finalizers: Option[Seq[String]] = None
)

object NamespaceSpec {
  implicit lazy val encoder: Encoder.AsObject[NamespaceSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceSpec] = deriveDecoder
}
