package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
 *
 *  @param ports  ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical
 *                OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this
 *                field is present and contains at least one item, then this rule allows traffic only if the traffic matches
 *                at least one port in the list.
 *  @param    to  to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are
 *                combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations
 *                (traffic not restricted by destination). If this field is present and contains at least one item, this rule
 *                allows traffic only if the traffic matches at least one item in the to list.
*/
case class NetworkPolicyEgressRule(
  ports: Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None,
  to: Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None
)

object NetworkPolicyEgressRule {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyEgressRule] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyEgressRule] = deriveDecoder
}
