package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
 *
 *  @param           ipBlock  ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other
 *                            fields can be.
 *  @param namespaceSelector  namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard
 *                            label selector semantics; if present but empty, it selects all namespaces.
 *                            If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector
 *                            in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces
 *                            selected by namespaceSelector.
 *  @param       podSelector  podSelector is a label selector which selects pods. This field follows standard label selector
 *                            semantics; if present but empty, it selects all pods.
 *                            If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching
 *                            podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching
 *                            podSelector in the policy's own namespace.
*/
case class NetworkPolicyPeer(
  ipBlock: Option[io.k8s.api.networking.v1.IPBlock] = None,
  namespaceSelector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  podSelector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
)

object NetworkPolicyPeer {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyPeer] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyPeer] = deriveDecoder
}
