package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicyPort describes a port to allow traffic on
 *
 *  @param  endPort  endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by
 *                   the policy. This field cannot be defined if the port field is not defined or if the port field is defined
 *                   as a named (string) port. The endPort must be equal or greater than port.
 *  @param     port  port represents the port on the given protocol. This can either be a numerical or named port on a pod.
 *                   If this field is not provided, this matches all port names and numbers. If present, only traffic on the
 *                   specified protocol AND port will be matched.
 *  @param protocol  protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this
 *                   field defaults to TCP.
*/
case class NetworkPolicyPort(
  endPort: Option[Int] = None,
  port: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  protocol: Option[String] = None
)

object NetworkPolicyPort {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyPort] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyPort] = deriveDecoder
}
