package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers.
 *
 *  @param supplementalGroupsPolicy  SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy
 *                                   and ContainerUser.
*/
case class NodeFeatures(
  supplementalGroupsPolicy: Option[Boolean] = None
)

object NodeFeatures {
  implicit lazy val encoder: Encoder.AsObject[NodeFeatures] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeFeatures] = deriveDecoder
}
