package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeRuntimeHandler is a set of runtime handler information.
 *
 *  @param features  Supported features.
 *  @param     name  Runtime handler name. Empty for the default runtime handler.
*/
case class NodeRuntimeHandler(
  features: Option[io.k8s.api.core.v1.NodeRuntimeHandlerFeatures] = None,
  name: Option[String] = None
)

object NodeRuntimeHandler {
  implicit lazy val encoder: Encoder.AsObject[NodeRuntimeHandler] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeRuntimeHandler] = deriveDecoder
}
