package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
 *
 *  @param recursiveReadOnlyMounts  RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts
 *  @param          userNamespaces  UserNamespaces is set to true if the runtime handler supports UserNamespaces, including
 *                                  for volumes.
*/
case class NodeRuntimeHandlerFeatures(
  recursiveReadOnlyMounts: Option[Boolean] = None,
  userNamespaces: Option[Boolean] = None
)

object NodeRuntimeHandlerFeatures {
  implicit lazy val encoder: Encoder.AsObject[NodeRuntimeHandlerFeatures] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeRuntimeHandlerFeatures] = deriveDecoder
}
