package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeSpec describes the attributes that a node is created with.
 *
 *  @param  configSource  Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig
 *                        feature. This feature is removed.
 *  @param    externalID  Deprecated. Not all kubelets will set this field. Remove field after 1.13. see:
 *                        https://issues.k8s.io/61966
 *  @param       podCIDR  PodCIDR represents the pod IP range assigned to the node.
 *  @param      podCIDRs  podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field
 *                        is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each
 *                        of IPv4 and IPv6.
 *  @param    providerID  ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
 *  @param        taints  If specified, the node's taints.
 *  @param unschedulable  Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info:
 *                        https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
*/
case class NodeSpec(
  configSource: Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  externalID: Option[String] = None,
  podCIDR: Option[String] = None,
  podCIDRs: Option[Seq[String]] = None,
  providerID: Option[String] = None,
  taints: Option[Seq[io.k8s.api.core.v1.Taint]] = None,
  unschedulable: Option[Boolean] = None
)

object NodeSpec {
  implicit lazy val encoder: Encoder.AsObject[NodeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSpec] = deriveDecoder
}
