package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
 *
 *  @param         apiVersion  API version of the referent.
 *  @param               kind  Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param               name  Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
 *  @param                uid  UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
 *  @param blockOwnerDeletion  If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted
 *                             from the key-value store until this reference is removed. See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion
 *                             for how the garbage collector interacts with this field and enforces the foreground deletion.
 *                             Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise
 *                             422 (Unprocessable Entity) will be returned.
 *  @param         controller  If true, this reference points to the managing controller.
*/
case class OwnerReference(
  apiVersion: String,
  kind: String,
  name: String,
  uid: String,
  blockOwnerDeletion: Option[Boolean] = None,
  controller: Option[Boolean] = None
)

object OwnerReference {
  implicit lazy val encoder: Encoder.AsObject[OwnerReference] = deriveEncoder
  implicit lazy val decoder: Decoder[OwnerReference] = deriveDecoder
}
