package io.k8s.api.networking.v1beta1

import io.circe.*
import io.circe.generic.semiauto.*

/** ParentReference describes a reference to a parent object.
 *
 *  @param  resource  Resource is the resource of the object being referenced.
 *  @param      name  Name is the name of the object being referenced.
 *  @param     group  Group is the group of the object being referenced.
 *  @param namespace  Namespace is the namespace of the object being referenced.
*/
case class ParentReference(
  resource: String,
  name: String,
  group: Option[String] = None,
  namespace: Option[String] = None
)

object ParentReference {
  implicit lazy val encoder: Encoder.AsObject[ParentReference] = deriveEncoder
  implicit lazy val decoder: Decoder[ParentReference] = deriveDecoder
}
