package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PersistentVolumeClaimCondition contains details about state of pvc
 *
 *  @param             `type`
 *  @param             status
 *  @param      lastProbeTime  lastProbeTime is the time we probed the condition.
 *  @param lastTransitionTime  lastTransitionTime is the time the condition transitioned from one status to another.
 *  @param            message  message is the human-readable message indicating details about last transition.
 *  @param             reason  reason is a unique, this should be a short, machine understandable string that gives the reason
 *                             for condition's last transition. If it reports "Resizing" that means the underlying persistent
 *                             volume is being resized.
*/
case class PersistentVolumeClaimCondition(
  `type`: String,
  status: String,
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object PersistentVolumeClaimCondition {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimCondition] = deriveDecoder
}
