package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodIP represents a single IP address allocated to the pod.
 *
 *  @param ip  IP is the IP address assigned to the pod
*/
case class PodIP(
  ip: String
)

object PodIP {
  implicit lazy val encoder: Encoder.AsObject[PodIP] = deriveEncoder
  implicit lazy val decoder: Decoder[PodIP] = deriveDecoder
}
