package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodOS defines the OS parameters of a pod.
 *
 *  @param name  Name is the name of the operating system. The currently supported values are linux and windows. Additional
 *               value may be defined in future and can be one of: https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration
 *               Clients should expect to handle additional values and treat unrecognized values in this field as os: null
*/
case class PodOS(
  name: String
)

object PodOS {
  implicit lazy val encoder: Encoder.AsObject[PodOS] = deriveEncoder
  implicit lazy val decoder: Decoder[PodOS] = deriveDecoder
}
