package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodResourceClaimStatus is stored in the PodStatus for each PodResourceClaim which references a ResourceClaimTemplate. It stores the generated name for the corresponding ResourceClaim.
 *
 *  @param              name  Name uniquely identifies this resource claim inside the pod. This must match the name of an entry
 *                            in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
 *  @param resourceClaimName  ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace
 *                            of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims
 *                            entry can be ignored in this case.
*/
case class PodResourceClaimStatus(
  name: String,
  resourceClaimName: Option[String] = None
)

object PodResourceClaimStatus {
  implicit lazy val encoder: Encoder.AsObject[PodResourceClaimStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PodResourceClaimStatus] = deriveDecoder
}
