package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodSchedulingGate is associated to a Pod to guard its scheduling.
 *
 *  @param name  Name of the scheduling gate. Each scheduling gate must have a unique name field.
*/
case class PodSchedulingGate(
  name: String
)

object PodSchedulingGate {
  implicit lazy val encoder: Encoder.AsObject[PodSchedulingGate] = deriveEncoder
  implicit lazy val decoder: Decoder[PodSchedulingGate] = deriveDecoder
}
